//RECV000B JOB (SYS),'TSO RECEIVE XMI',          <-- Review and Modify
//             CLASS=A,MSGCLASS=X,REGION=0M,     <-- Review and Modify
//             MSGLEVEL=(1,1),NOTIFY=&SYSUID     <-- Review and Modify
//* -------------------------------------------------------*
//* *  JOB: $RECVTSO  TSO RECEIVE APPLICATION XMI FILES    *
//* *                 for DUMAPD software distribution     *
//* -------------------------------------------------------*
//*
//*    This JOB executes two steps:
//*
//*     1) IDCAMS to ensure parent HLQ alias (SHRABIT) is
//*        defined on master catalog
//*        Note: Alias definition bypassed if alias already
//*        ----- defined.
//*
//*     2) Executes TSO in BATCH mode and issues  
//*        TSO RECEIVE commands to load the XMI distribution
//*        library (an XMI SEQ dataset) to a temporary PDS.
//*        Each software PDS is loaded from before deleting
//*        temporary PDS.
//*
//*
//*    This JCL may be modified to suit your installation
//*    needs.                                                
//*
//*    The TSO RECEIVE commands use INdataset, DAtaset, VOL,
//*    and NOPRompt parms.
//*
//*
//* -------------------------------------------------------*
//* *                                                      *
//* *  PROC: PBTSO                                         *
//* *       Batch TSO                                      *
//* *                                                      *
//* -------------------------------------------------------*
//PBTSO    PROC
//STEP01   EXEC PGM=IKJEFT01
//SYSPROC  DD  DISP=SHR,DSN=SYS2.CMDPROC           
//*STEPLIB  DD  DISP=SHR,DSN=SYS2.LINKLIB           
//SYSPRINT DD  SYSOUT=*
//SYSTSPRT DD  SYSOUT=*
//SYSTSIN  DD  DUMMY       Command Line Input
//*
//         PEND
//*
//* -------------------------------------------------------*
//* Ensure parent HLQ alias is declared
//* -------------------------------------------------------*
//DEFALIAS EXEC PGM=IDCAMS 
//SYSPRINT DD  SYSOUT=*
//SYSIN    DD  *
 PARM GRAPHICS(CHAIN(SN))
 LISTCAT ALIAS  ENT(SHRABIT)

 /* Review and modify catalog name below */                    
 IF LASTCC NE 0 THEN -
    DEFINE ALIAS(NAME(SHRABIT) RELATE(SYS1.UCAT.MVS))                          
/*                                                                      
//*
//* -------------------------------------------------------*
//* TSO RECEIVE DUMAPD Software Distribution
//* -------------------------------------------------------*
//TSORCV   EXEC PBTSO
//* -------------------------------------------------------*
//* Review and Modify the DSN of the transferred XMI           <-----
//* used in the TSO RECEIVE SYSTSIN DD.                        <-----
//* -------------------------------------------------------*
//STEP01.SYSTSIN DD *
 /* Modify 'SHRABIT.' with your parent HLQ, if different      */    
 /* Modify 'your.transfer.xmi' with transferred XMI SEQ DSN   */    
 /* Modify 'volser' with VOLSER on your system                */    
RECEIVE IN('your.transfer.xmi')          -  
        DA('SHRABIT.DUMAPD.V0R9M00.XMIPDS')   -  
        VOL(volser)              NOPROMPT   
 /* Receive CNTL                      */    
RECEIVE IN('SHRABIT.DUMAPD.V0R9M00.XMIPDS(CNTL)') -  
        DA('SHRABIT.DUMAPD.V0R9M00.CNTL')     -  
        VOL(volser)              NOPROMPT   
 /* Receive HELP                      */    
RECEIVE IN('SHRABIT.DUMAPD.V0R9M00.XMIPDS(HELP)') -  
        DA('SHRABIT.DUMAPD.V0R9M00.HELP')     -  
        VOL(volser)              NOPROMPT   
 /* Receive CLIST                     */    
RECEIVE IN('SHRABIT.DUMAPD.V0R9M00.XMIPDS(CLIST)') -  
        DA('SHRABIT.DUMAPD.V0R9M00.CLIST')    -  
        VOL(volser)              NOPROMPT   
 /* Receive ISPF                      */    
RECEIVE IN('SHRABIT.DUMAPD.V0R9M00.XMIPDS(ISPF)') -  
        DA('SHRABIT.DUMAPD.V0R9M00.ISPF')     -  
        VOL(volser)              NOPROMPT   
 /* Receive ASM                       */    
RECEIVE IN('SHRABIT.DUMAPD.V0R9M00.XMIPDS(ASM)') -  
        DA('SHRABIT.DUMAPD.V0R9M00.ASM')      -  
        VOL(volser)              NOPROMPT   
 /* Receive MACLIB                    */    
RECEIVE IN('SHRABIT.DUMAPD.V0R9M00.XMIPDS(MACLIB)') - 
        DA('SHRABIT.DUMAPD.V0R9M00.MACLIB')   -  
        VOL(volser)              NOPROMPT   
 /* Delete XMIPDS                     */    
DELETE  'SHRABIT.DUMAPD.V0R9M00.XMIPDS'          
/*
//
